


global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



use "E:\研究数据\中国城市统计年鉴\cityname_stata14.dta",clear
gen provid=int(cityid/100)
keep province provid east mid west
duplicates drop province ,force 
save "$DataPath\CH12\data_Provname.dta",replace 


use "$DataPath\CH12\data_ProvGDP.dta",clear
keep if 年份>=2000
gen province=省份
gen period=年份-1999

merge m:1 province using "$DataPath\CH12\data_Provname.dta"
drop _merge

save "$DataPath\CH12\data_ProvIndustry.dta",replace 






***读者从这里开始运行即可
use "$DataPath\CH12\data_ProvIndustry.dta",clear

bysort 年份:egen 工业GDP_total=sum(工业GDP)
replace 工业GDP=工业GDP/工业GDP_total*100

xtset provid period
gen GDP00=L22.工业GDP
gen GDP05=L17.工业GDP
gen GDP10=L12.工业GDP
gen GDP15=L7.工业GDP
gen GDP20=L2.工业GDP


**2010
reg GDP10 GDP00

twoway ///
(scatter GDP10 GDP00 if east!=1,mlabel(province) mlabcolor(gs6) mlabsize(vsmall) mcolor(gs6) msize(small)  msymbol(Th) )     ///
(scatter GDP10 GDP00 if east==1,mlabel(province) mlabcolor(gs4) mlabsize(vsmall) mcolor(gs4) msize(smalll) msymbol(S) )     ///
(lfit    GDP10 GDP00,clwidth(medthick) lpattern(solid) lcolor(gs8) ) ,                             ///
 scale(1.1)     scheme(s1color) legend(order(1 "内地省份"  2 "沿海省份" ) size(small))                               ///
graphregion(color(white))                                                             ///
xtitle("工业GDP的比重:   2000", size(small))  ///
ytitle("工业GDP的比重:   2010", size(small)) ///
ymtick(0(2)12) ylabel(0(2)12, angle(360))  ///
xmtick(0(2)12) xlabel(0(2)12) ///
text(8 4   `"{fontface "宋体":斜率}={stSerif:0.93}"', size(small))    ///
saving(GDP10,replace)  
graph export "$DataPath\CH12\图_12_12_工业发展的路径依赖_10.png", replace width(1600)


**2020
reg GDP20 GDP00

twoway ///
(scatter GDP20 GDP00 if east!=1,mlabel(province) mlabcolor(gs6) mlabsize(vsmall) mcolor(gs6) msize(small)  msymbol(Th) )     ///
(scatter GDP20 GDP00 if east==1,mlabel(province) mlabcolor(gs4) mlabsize(vsmall) mcolor(gs4) msize(smalll) msymbol(S) )     ///
(lfit    GDP20 GDP00,clwidth(medthick) lpattern(solid) lcolor(gs8) ) ,                             ///
 scale(1.1)     scheme(s1color) legend(order(1 "内地省份"  2 "沿海省份" ) size(small))                               ///
graphregion(color(white))                                                             ///
xtitle("工业GDP的比重:   2000", size(small))  ///
ytitle("工业GDP的比重:   2020", size(small)) ///
ymtick(0(2)12) ylabel(0(2)12, angle(360))  ///
xmtick(0(2)12) xlabel(0(2)12) ///
text(8 4   `"{fontface "宋体":斜率}={stSerif:0.95}"', size(small))    ///
saving(GDP20,replace)  
graph export "$DataPath\CH12\图_12_12_工业发展的路径依赖_20.png", replace width(1600)






***也可以直接合并
**2010
reg GDP10 GDP00

twoway ///
(scatter GDP10 GDP00,mlabel(province) mlabcolor(gs6) mcolor(gs6) msize(medsmall) msymbol(Th) )         ///
(lfit    GDP10 GDP00,clwidth(medthick) lpattern(solid) lcolor(gs4) ) ,                             ///
	   legend(off)    scale(1.1)     scheme(s1color)                              ///
graphregion(color(white))                                                             ///
ytitle(" (%)", size(med) orienta(horizontal)) ///
xtitle("初始工业GDP的比重", size(med))  ///
ymtick(0(2)12) ylabel(0(2)12, angle(360))  ///
xmtick(0(2)12) xlabel(0(2)12) ///
text(4 10   "斜率=0.93")    ///
saving("$DataPath\CH12\GDP10",replace)  



**2020
reg GDP20 GDP00

twoway ///
(scatter GDP20 GDP00,mlabel(province) mlabcolor(gs6) mcolor(gs6) msize(medsmall) msymbol(Th) )         ///
(lfit    GDP20 GDP00,clwidth(medthick) lpattern(solid) lcolor(gs4) ) ,                             ///
	   legend(off)    scale(1.1)     scheme(s1color)                              ///
graphregion(color(white))                                                             ///
ytitle(" (%)", size(med) orienta(horizontal)) ///
xtitle("初始工业GDP的比重", size(med))  ///
ymtick(0(2)12) ylabel(0(2)12, angle(360))  ///
xmtick(0(2)12) xlabel(0(2)12) ///
text(4 10   "斜率=0.95")    ///
saving("$DataPath\CH12\GDP20",replace)  


gr combine  GDP10.gph  GDP20.gph, rows(1) iscale(1)
graph export "$DataPath\CH12\图_12_12_工业发展的路径依赖_合并图.png", replace width(1600)


